//
//  MainViewController.m
//  AppSettings
//
//  Created by Robert Górczyński on 11-07-12.
//

#import "MainViewController.h"


@implementation MainViewController
@synthesize usernameLabel; 
@synthesize passwordLabel; 
@synthesize protocolLabel; 
@synthesize warpDriveLabel; 
@synthesize warpFactorLabel; 
@synthesize favoriteTeaLabel; 
@synthesize favoriteCandyLabel; 
@synthesize favoriteGameLabel; 
@synthesize favoriteExcuseLabel; 
@synthesize favoriteSinLabel; 

- (void)applicationWillEnterForeground:(NSNotification *)notification { 
    NSUserDefaults *defaults = [NSUserDefaults standardUserDefaults]; 
    [defaults synchronize]; 
    [self refreshFields]; 
}

- (void)refreshFields { 
    NSUserDefaults *defaults = [NSUserDefaults standardUserDefaults];
    usernameLabel.text = [defaults objectForKey:kUsernameKey]; 
    passwordLabel.text = [defaults objectForKey:kPasswordKey]; 
    protocolLabel.text = [defaults objectForKey:kProtocolKey]; 
    warpDriveLabel.text = [defaults objectForKey:kWarpDriveKey]; 
    warpFactorLabel.text = [[defaults objectForKey:kWarpFactorKey] 
                            stringValue]; 
    favoriteTeaLabel.text = [defaults objectForKey:kFavoriteTeaKey]; 
    favoriteCandyLabel.text = [defaults objectForKey:kFavoriteCandyKey]; 
    favoriteGameLabel.text = [defaults objectForKey:kFavoriteGameKey]; 
    favoriteExcuseLabel.text = [defaults objectForKey:kFavoriteExcuseKey]; 
    favoriteSinLabel.text = [defaults objectForKey:kFavoriteSinKey]; 
} 

- (void)viewDidAppear:(BOOL)animated { 
    [self refreshFields]; 
    [super viewDidAppear:animated]; 
} 



// Implementacja metody viewDidLoad pozwala na przeprowadzenie konfiguracji po wczytaniu widoku, zazwyczaj z pliku nib.
- (void)viewDidLoad {
	[super viewDidLoad];
    UIApplication *app = [UIApplication sharedApplication]; 
    [[NSNotificationCenter defaultCenter] addObserver:self 
											 selector:@selector(applicationWillEnterForeground:) 
												 name:UIApplicationWillEnterForegroundNotification 
											   object:app]; 	
}


- (void)flipsideViewControllerDidFinish:(FlipsideViewController *)controller {
    [self refreshFields];
	[self dismissModalViewControllerAnimated:YES];
}


- (IBAction)showInfo:(id)sender {    
	
	FlipsideViewController *controller = [[FlipsideViewController alloc] initWithNibName:@"FlipsideView" bundle:nil];
	controller.delegate = self;
	
	controller.modalTransitionStyle = UIModalTransitionStyleFlipHorizontal;
	[self presentModalViewController:controller animated:YES];
	
	[controller release];
}


- (void)didReceiveMemoryWarning {
	// Jeżeli widok nie posiada widoku nadrzędnego, wówczas zostanie usunięty z pamięci.
    [super didReceiveMemoryWarning];
	
	// Usunięcie z pamięci wszelkich buforowanych danych, obrazów i innych zasobów, które obecnie nie są używane.
}


- (void)viewDidUnload {
	// Usunięcie wszystkich „przytrzymanych” podwidoków widoku głównego,
    // na przykład self.myOutlet = nil;
	[[NSNotificationCenter defaultCenter] removeObserver:self]; 
    self.usernameLabel = nil; 
    self.passwordLabel = nil; 
    self.protocolLabel = nil; 
    self.warpDriveLabel = nil; 
    self.warpFactorLabel = nil; 
    self.favoriteTeaLabel = nil; 
    self.favoriteCandyLabel = nil; 
    self.favoriteGameLabel = nil; 
    self.favoriteExcuseLabel = nil; 
    self.favoriteSinLabel = nil; 
	[super viewDidUnload]; 
}


- (void)dealloc {
    [usernameLabel release]; 
    [passwordLabel release]; 
    [protocolLabel release]; 
    [warpDriveLabel release]; 
    [warpFactorLabel release]; 
    [favoriteTeaLabel release]; 
    [favoriteCandyLabel release]; 
    [favoriteGameLabel release]; 
    [favoriteExcuseLabel release]; 
    [favoriteSinLabel release]; 	
    [super dealloc];
}


@end
